/*
 * Decompiled with CFR 0.152.
 */
package GameState;

import Entity.MenuOption;
import Entity.Mouse;
import GameState.GameState;
import GameState.GameStateManager;
import Handlers.Keys;
import Handlers.Options;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class CreditsState
extends GameState {
    private Font font;
    private MenuOption mo;
    private Mouse mouse;

    public CreditsState(GameStateManager gsm) {
        this.gsm = gsm;
        this.font = new Font("Arial", 0, 22);
        this.mo = new MenuOption("Back", gsm.regFont, 400, 350);
        this.mouse = new Mouse();
    }

    @Override
    public void init() {
    }

    @Override
    public void update() {
        this.handleInput();
        this.mo.update(this.mouse);
        this.mouse.update();
    }

    @Override
    public void draw(Graphics2D g) {
        g.setFont(this.font);
        g.setColor(Color.WHITE);
        this.gsm.drawCenteredString("Created by Darryl Day", 800, 360, g);
        this.gsm.drawCenteredString("Not all Sprites and Music/SFX are made by me,", 800, 440, g);
        this.gsm.drawCenteredString("read the credits.txt file in your Documents/CometDefender folder", 800, 490, g);
        g.setFont(this.gsm.regFont);
        if (Options.getOption(5)) {
            this.mo.draw(g);
            this.mouse.draw(g);
        } else {
            g.setColor(Color.yellow);
            this.gsm.drawCenteredString("Back", 800, 700, g);
        }
    }

    @Override
    public void handleInput() {
        if (Keys.isKeyPressed(Keys.ESCAPE)) {
            this.gsm.setState(0);
        }
        if (Options.getOption(5)) {
            if (Keys.isMousePressed(Keys.LEFTCLICK) && this.mo.getChoice() == 0) {
                this.gsm.setState(0);
            }
        } else if (Keys.isKeyPressed(Keys.ENTER)) {
            this.gsm.setState(0);
        }
    }
}

